﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

using System.Threading;


public class Destroy : MonoBehaviour
{

    public Text text;
    public GameObject player;
    public GameObject platformPrefab;
    public GameObject springPrefab;
    public GameObject brokenPlatformPrefab;
    public GameObject blackHolePrefab;
    public GameObject hatPrefab;
    public GameObject platformForHatPrefab;
    public GameObject HatPlayerPlayer;

    private float posHat;

    // Start is called before the first frame update
    void Start()
    {
        
    }

    //Update is called once per frame
    void Update()
    {

    }


    //toutes les plateformes sont détruites ou reporté plus haut sur la map avec le gameobject vide DESTROYER attaché au personnage.

    private void OnTriggerEnter2D(Collider2D collision)
    {

	//Si le DESTROYER atteint une plateforme verte, alors :
	// cette plateforme est reporté au dessus
	// 1 fois sur 7, la plateform verte et détruite et remplacé par une plateforme bleu
	// 1 fois sur 7, nous générons une plateforme marron
	// 1 fois sur 200, nous générons un trou noir
	// 1 fois sur 100, nous générons un chapeau à hélices


        if(collision.gameObject.name.StartsWith("Platform"))
        {
            if (Random.Range(1, 7) == 1)
            {

                Destroy(collision.gameObject);
                Instantiate(springPrefab, new Vector2(Random.Range(-4.5f, 4.5f), player.transform.position.y + (14 + Random.Range(0.2f, 1.0f))), Quaternion.identity);


            } else
            {

                collision.gameObject.transform.position = new Vector2(Random.Range(-4.5f, 4.5f), player.transform.position.y + (14 + Random.Range(0.2f, 1.0f)));

            }


			if (Random.Range(1, 7) == 1)
            		{
				Instantiate(brokenPlatformPrefab, new Vector2(Random.Range(-4.5f, 4.5f), player.transform.position.y + (14 + Random.Range(0.75f, 1.0f))), Quaternion.identity);
	    		}

	   		if (Random.Range(1, 200) == 1)
	    		{
 				Destroy(collision.gameObject);
				Instantiate(blackHolePrefab, new Vector2(Random.Range(-8.5f, 8.5f), player.transform.position.y + (14 + Random.Range(0f, 0f))), Quaternion.identity);
	    		}

	    		if (Random.Range(1, 100) == 1)
	    		{
				posHat = Random.Range(-4.5f,4.5f);
 				Destroy(collision.gameObject);
				Instantiate(hatPrefab, new Vector2(posHat, player.transform.position.y + (14 + Random.Range(1.75f, 1.75f))), Quaternion.identity);
				Instantiate(platformForHatPrefab, new Vector2(posHat, player.transform.position.y + (14 + Random.Range(0f, 0f))), Quaternion.identity);

	   		}



	//Si le DESTROYER atteint une plateforme bleue, alors :
	// 1 fois sur 7 nous reportons la plateforme bleue plus haut
	// 6 fois sur 7, elle est détruite et on crée une plateforme verte


        } else if(collision.gameObject.name.StartsWith("Spring"))
        {

            if (Random.Range(1, 7) == 1)
            {

                collision.gameObject.transform.position = new Vector2(Random.Range(-4.5f, 4.5f), player.transform.position.y + (14 + Random.Range(0.2f, 1.0f)));

            }
            else
            {

                Destroy(collision.gameObject);
                Instantiate(platformPrefab, new Vector2(Random.Range(-4.5f, 4.5f), player.transform.position.y + (14 + Random.Range(0.75f, 1.0f))), Quaternion.identity);


            }

        }


	//Si le DESTROYER atteint une plateforme marron, alors :
	// cette plateforme est détruite

	if(collision.gameObject.name.StartsWith("Broken"))
        {

                Destroy(collision.gameObject);
	
	}   

    }

}
